import { Component, Renderer2 } from '@angular/core';
import { environment } from '../../../environments/environment';

@Component({
  selector: 'app-landing',
  templateUrl: './landing.component.html',
  styleUrls: ['./landing.component.scss'],
})
export class LandingComponent {
  landingSmallVideo = `${environment.filesUrl}/landing/front-video.mp4`;

  constructor(private readonly renderer: Renderer2) {}

  openUrl(url: string): void {
    const aTag: HTMLInputElement = this.renderer.createElement('a');
    this.renderer.setAttribute(aTag, 'href', url);
    aTag.click();
  }
}
