// `.env.ts` is generated by the `npm run env` command
// `npm run env` exposes environment variables as JSON for any usage you might
// want, like displaying the version or getting extra config from your CI bot, etc.
// This is useful for granularity you might need beyond just the environment.
// Note that as usual, any environment variables you expose through it will end up in your
// bundle, and you should not use it for any sensitive information like passwords or keys.
import env from './.env';

export const environment = {
  production: true,
  version: env.npm_package_version,
  serverUrl: 'https://api.xdaro.teamxi.cloud/api',
  defaultLanguage: 'EN',
  credentialsKey: 'credentials',
  socketHost: 'https://api.xdaro.teamxi.cloud/',
  sumSubClient: 'primabanq',
  landingUrl: 'https://xdaro.teamxi.cloud/',
  supportedLanguages: [
    'EN'
  ],
  captchaSiteKey: 'production_site_key',
  clientSource: 'XDARO',
  sumSubScript: 'https://api.sumsub.com/idensic/static/sumsub-kyc.js',
  userIdleConfig: {idle: 300, timeout: 30, ping: 60}
};
