import { BankAccount } from './BankAccount';
import { KycTier } from '../objects/KycTier';

export interface UserProfile {
    avatar?: string;
    username?: string;
    firstName?: string;
    lastName?: string;
    birthDate?: Date;
    address?: string;
    address2?: string;
    city?: string;
    country?: string;
    state?: string;
    postalCode?: string;
    mobileNumber?: string;
}

export interface User {
    email: string;
    kycVerificationStatus?: number;
    emailConfirmed?: boolean;
    emailConfirmationResent?: boolean;
    twoFactorAuthEnabled?: boolean;
    kycTier?: number;
    recoveryEmail?: string;
    recoveryEmailConfirmed?: boolean;
    recoveryNumber?: string;
    recoveryNumberConfirmed?: boolean;
    hideValues?: boolean;
    whitelistEnabled?: boolean;
    detained?: boolean;
    detainedReason?: string;
    kyc?: KycTier[];
    clientId?: string;
    type?: string;
    bankAccount?: BankAccount;
    companyName?: string;
    companyRegNumber?: string;
    companyAddress?: string;
    companyCountry?: string;

    // User profile data
    profile?: UserProfile;
}
