import { Injectable } from '@angular/core';
import { SocketSubServiceResolvable } from '@app/core/socket/SocketSubServiceResolvable';
import { SocketService } from '@app/core/socket/SocketService';
import { HttpClient } from '@angular/common/http';
import { SwalService } from './SwalService';

@Injectable()
export class TicketService extends SocketSubServiceResolvable<number>{
  protected socket: SocketIOClient.Socket;
  public ticketCount = 0;

  constructor(
    private readonly httpClient: HttpClient,
    protected readonly socketService: SocketService,
    private readonly swalService: SwalService
  ) {
    super('tickets', socketService);
  }

  public resolve(): Promise<number> {
    return super.resolve();
  }

  private startLoadData(): void {
    this.socket.once('dataR', (data: number) => {
      this.ticketCount = data;
      this.eventSubject.next({name: 'data_loaded', args: [this.ticketCount]});
    });

    this.socket.emit('data');
  }

  protected onConnect(): void {
    this.startLoadData();
  }

  protected onClear(): void {
    super.onClear();
    this.ticketCount = 0;
  }

  // private listeners
  protected initListeners(): void {
    this.socket.on('update', (data: any) => {
      this.ticketCount = data.count;
    });

    this.socket.on('new', (data: any) => {
      this.ticketCount = data.count;
    });
  }

  private showToast(ticket: any): void {
    // if (transaction.status == 3) {
    //   this.swalService.showToast({title: "SWAL.TOAST_RECEIVE_TX_PENDING", titleParams, type: 'info', timer: 10000});
    // } else if (transaction.status == 5) {
    //   this.swalService.showToast({title: "SWAL.TOAST_RECEIVE_TX_COMPLETE", titleParams, type: 'success', timer: 10000});
    // }
  }
}
