import { Injectable } from '@angular/core';

export enum RestrictedType {
    IBAN = 'iban',
    TRUST = 'trust',
    PHYSICALCARD = 'physicalCard',
    VIRTUALCARD = 'virtualCard'
}

@Injectable({
    providedIn: 'root'
})
export class PermissionService {
    public permissions: string[] = [];
    public roles: string[] = [];
    public restricted: string[] = [];

    // public hasPermission(name: string) {
    //     if (this.permissions) {
    //         if (this.permissions.find(v => v == name)) {
    //             return true;
    //         }
    //     }
    //     return false;
    // }

    // public hasRole(name: string) {
    //     if (this.roles) {
    //         if (this.roles.find(v => v == name)) {
    //             return true;
    //         }
    //     }
    //     return false;
    // }

    // public isNotRestricted(restric: string[]) {
    //     if (this.restricted && restric && restric.length > 0) {
    //         for (const key in restric) {
    //             if (Object.prototype.hasOwnProperty.call(restric, key)) {
    //                 const element = restric[key];
    //                 if (this.restricted.find(v => v == element)) {
    //                     return false;
    //                 }
    //             }
    //         }
    //     }
    //     return true;
    // }

    public restrictedIfAll(restrict: string[]): boolean {
        if (this.restricted && restrict && restrict.length > 0) {
            return restrict.every(i => this.restricted.includes(i));
        }
        return false;
    }

    public isRestricted(restric: string[]): boolean {
        if (this.restricted && restric && restric.length > 0) {
            for (const key in restric) {
                if (Object.prototype.hasOwnProperty.call(restric, key)) {
                    const element = restric[key];
                    if (this.restricted.find(v => v === element)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
    public setPermissions(roles: string[], permissions: string[], restricted: string[]): void {
        this.roles = roles;
        this.permissions = permissions;
        this.restricted = restricted;
    }

    // public canAccessRoute(routeUrl: string) {
    //     for (let key of Object.keys(MenuRoles)) {
    //         if (routeUrl.startsWith(MenuRoles[key].defaultRoute)) {
    //             return true;
    //         }
    //     }
    //     return false;
    // }

    public getDefaultRouterLink(): string {
        return '/wallets';
    }
}
