import { KycTierLimit } from './../types/KycTierLimit';
import { Observable } from 'rxjs';
import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Resolve } from '@angular/router';

@Injectable({providedIn: 'root'})
export class KycTierService implements Resolve<any[]> {
  public kycTiers: any[] = [];

  constructor(
    private readonly httpClient: HttpClient,
  ) {
  }

  public getTier(tier: number, type: string, subType: string): any {
    return this.kycTiers.find(v => v.tier === tier && v.type === type && v.subType === subType);
  }

  public resolve(): Promise<any[]> {
    return new Promise(async (resolve, reject) => {
        try {
            this.kycTiers = await this.httpClient.get<any[]>('/settings/tier/list').toPromise();
            resolve(this.kycTiers);
        } catch (err) {
            reject(err);
        }
    });
  }

  public getTierLimits(): Observable<any> {
    return this.httpClient.get<KycTierLimit[]>('/identity/limit');
  }
}
