import { Injectable, OnDestroy } from '@angular/core';
import { MatDialogRef, MatDialog } from '@angular/material/dialog';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs';

@Injectable({
    providedIn: 'root'
})
export class IdlerService implements OnDestroy {
    private onTimerStart: Subscription = null;
    private onTimeout: Subscription = null;
    private onPing: Subscription = null;

    private dialogRef: MatDialogRef<any>;

    constructor(
        public readonly dialog: MatDialog,
        private readonly router: Router
    ) {
        // this.userIdle.setConfigValues(environment.userIdleConfig);
    }

    startIdler(): void {
        this.stopIdler();

        // this.userIdle.startWatching();
        // this.onPing = this.userIdle.ping$.subscribe(() => {})
        // this.onTimerStart = this.userIdle.onTimerStart().subscribe(count => {
        //     if (count === 1) {
        //           this.dialogRef = this.dialog.open(InactivityDialogComponent, {
        //             width: '400px',
        //             data: {}
        //         });

        //         this.dialogRef.afterClosed().subscribe(res => {
        //             if (res && res.continue) {
        //                 this.restartIdler();
        //             } else {
        //                 this.router.navigate(['/login']);
        //                 this.stopIdler();
        //             }
        //         });
        //     }

        //     if (this.dialogRef) {
        //         const time = environment.userIdleConfig.timeout - count;
        //         this.dialogRef.componentInstance.onTimer(time);
        //     }
        // });

        // this.onTimeout = this.userIdle.onTimeout().subscribe(() => {
        //     if (this.dialogRef) {
        //         this.dialogRef.close();
        //     }
        //     this.router.navigate(['/login']);
        // });
    }

    public stopIdler(): void {
        // this.userIdle.stopWatching();
        // this.userIdle.stopTimer();

        if (this.onTimerStart) {
            this.onTimerStart.unsubscribe();
            this.onTimerStart = null;
        }
        if (this.onTimeout) {
            this.onTimeout.unsubscribe();
            this.onTimeout = null;
        }
        if (this.onPing) {
            this.onPing.unsubscribe();
            this.onPing = null;
        }
    }

    restartIdler(): void {
        // this.userIdle.resetTimer();
    }

    ngOnDestroy(): void {
        this.stopIdler();
    }
}
