import { Injectable } from '@angular/core';
import { MatIconRegistry } from '@angular/material/icon';
import { DomSanitizer } from '@angular/platform-browser';
import { Logger } from '@app/core/LoggerService';

@Injectable()
export class IconService {
  private readonly logger = new Logger(IconService.name);

  private prefixIcons = 'local:assets/icons/';
  private prefixCurrencyIcons = 'local:assets/currency-icons/';

  // custom icons (.svg only) from assets folder
  // if icon css doesn't work check if svg contains fill
  private customIcons = {
    see_eye: 'see.svg',
    see_eye_no: 'see-no.svg',
    settings: 'settings.svg',
    accounts: 'accounts.svg',
    help_circle: 'help-circle.svg',
    copy_icon: 'copy.svg',
    plus_circle: 'plus.svg',
    plus: 'plus-1.svg',
    message_circle: 'message-circle.svg',
    menu: 'menu.svg',
    trash: 'trash.svg',
    vault: 'vault.svg',
    info: 'i.svg',
    logout: 'logout.svg',
    address_book: 'address-book.svg',
    calendar: 'calendar.svg',
    check_circle: 'check-circle.svg',
    camera: 'camera.svg',
    attachment: 'attachment.svg',
    remove: 'x.svg',
    transactions: 'transactions.svg',
    download: 'download.svg',
    three_dots_vertical: 'three-dots-vertical.svg',
    qr_icon: 'QR-icon.svg',
    shield: 'shield.svg',
    pricing: 'pricing.svg'
  };

  private currencyIcons = {
    currency_BTC: 'BTC.svg',
    currency_DASH: 'DASH.svg',
    currency_DOLLAR: 'DOLLAR.svg',
    currency_ETH: 'ETH.svg',
    currency_EUR: 'EUR.svg',
    currency_EUR_TRUST: 'EUR_TRUST.svg',
    currency_LTC: 'LTC.svg',
    currency_MOF: 'MOF.svg',
    currency_USD_TRUST: 'USD_TRUST.svg',
    currency_USDC: 'USDC.svg',
    currency_USDT: 'USDT.svg',
  };

  constructor(
    private readonly matIconRegistry: MatIconRegistry,
    private readonly domSanitizer: DomSanitizer
  ) {
  }

  loadCustomIcons(): void {
    try {
      // tslint:disable-next-line: forin
      for (const key in this.customIcons) {
        this.loadIcon(this.customIcons, key, this.prefixIcons);
      }

      // tslint:disable-next-line: forin
      for (const key in this.currencyIcons) {
        this.loadIcon(this.currencyIcons, key, this.prefixCurrencyIcons);
      }
    } catch (err) {
      this.logger.error(err);
    }
  }

  loadIcon(iconArray: object, iconName: string, prefixPath: string): void {
    if (iconArray.hasOwnProperty(iconName)) {
      const path = prefixPath + iconArray[iconName];
      this.matIconRegistry.addSvgIcon(iconName, this.domSanitizer.bypassSecurityTrustResourceUrl(path));
    } else {
      this.logger.warn(`Icon ${iconName} doesn't exist`);
    }
  }
}
