import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Resolve } from '@angular/router';

export interface EntryStatus {
    registrationEnabled: boolean;
    registrationDisabledReason: string;
    invitationEnabled: boolean;
    regionRestricted: boolean;
}

@Injectable({providedIn: 'root'})
export class EntryService implements Resolve<any> {
    public data: EntryStatus = null;
    public error = false;

    constructor(
        private readonly httpClient: HttpClient
    ){
    }

    async resolve(): Promise<any> {
        try {
            this.data = await this.httpClient.disableAuthToken().get<EntryStatus>('/service/status').toPromise();
        } catch (err) {
            this.error = true;
        }

        return Promise.resolve();
    }
}
