import { WalletTypes } from './../constant/WalletTypes';
import { Pipe, PipeTransform } from '@angular/core';

@Pipe({ name: 'walletTypeLabel', pure: false })
export class WalletTypesLabelPipe implements PipeTransform {
  private readonly walletTypes = WalletTypes;

  transform(value: string): string {
    const walletType = this.walletTypes.find(type => type.value === value);
    return walletType ? walletType.viewValue : value;
  }
}
