import { Pipe, PipeTransform } from '@angular/core';
import { TransactionService } from '../services/TransactionService';
import Transaction from '../objects/Transaction';
import { isEmpty } from '../Helper';
import Account from '../objects/Account';

@Pipe({ name: 'transactions', pure: false })
export class TransactionPipe implements PipeTransform {
  constructor(private transactionService: TransactionService) {
  }

  transform(key: number | Account | 'all', count?: number): Transaction[] {
    let list: Transaction[];

    if (typeof key === 'string'){
      list = this.transactionService.all;
    } else {
      list = this.transactionService.getByAccount(key);
    }

    if (isEmpty(list)){
      return [];
    }

    if (count && count > 0 && list.length > count){
      return list.slice(0, count);
    }

    return list;
  }
}
