import { Pipe, Injectable, PipeTransform } from '@angular/core';
import { CurrencyService } from '../services/CurrencyService';
import { isEmpty } from '../Helper';
import { Currency } from '../objects/Currency';

@Pipe({ name: 'singleCurrency', pure: false })
@Injectable()
export class CurrencyPipe implements PipeTransform {
  constructor(private readonly currencyService: CurrencyService) {
  }

  transform(key: string): Currency {
    if (isEmpty(key)) {
      return null;
    }

    if (key === 'default'){
      return this.currencyService.currency();
    } else {
      return this.currencyService.currency(key);
    }
  }
}
