import { Pipe, Injectable, PipeTransform } from '@angular/core';
import { CurrencyService } from '../services/CurrencyService';
import { isEmpty } from '../Helper';
import { Currency } from '../objects/Currency';


@Pipe({ name: 'currencies', pure: false })
@Injectable()
export class CurrenciesPipe implements PipeTransform {
  constructor(private readonly currencyService: CurrencyService) {
  }

  transform(key: string | string[], select?: 'rates'): Currency | Currency[] {
    if (isEmpty(key)) {
      return [];
    }

    if (typeof key === 'string'){
      if (key === 'all' || isEmpty(key)){
        return this.currencyService.all;
      } else if (key === 'default'){
        return this.currencyService.currency();
      } else if (key === 'crypto'){
        return this.currencyService.getByType('crypto');
      } else if (key === 'internal'){
        return this.currencyService.getByType('internal');
      }
      key = [key];
    }

    // TODO: rework
    const res = [];
    for (const code of key) {
      const curr = this.currencyService.currency(code);
      if (!curr) {
        continue;
      }
      switch (select){
        case 'rates':
          // we need to get all rates
          for (const rate of Object.keys(curr.rates)){
            const r = this.currencyService.currency( rate as string);

            if (r) {
              res.push(r);
            }
          }
          break;
        default: res.push(curr);
      }
    }
    return res;
  }
}
