import { AssetTypes } from './../constant/AssetTypes';
import { Pipe, PipeTransform } from '@angular/core';

@Pipe({ name: 'assetTypeLabel', pure: false })
export class AssetTypesLabelPipe implements PipeTransform {
  private readonly assetTypes = AssetTypes;

  transform(value: string): string {
    const assetType = this.assetTypes.find(type => type.value === value);
    return assetType ? assetType.viewValue : value;
  }
}
