import { Pipe, PipeTransform } from '@angular/core';
import { AccountService } from '../services/AccountService';
import { isEmpty } from '../Helper';
import Account from '../objects/Account';

@Pipe({ name: 'accounts', pure: false })
export class AccountsPipe implements PipeTransform {
  constructor(private readonly accountService: AccountService) {
  }

  transform(key: string, codeTo?: string): Account[];
  transform(key: string | string[], codeTo?: string): Account[] {

    if (Array.isArray(key)) {
      return this.accountService.getByCurrencies(key);
    }

    if (key === 'all' || isEmpty(key)){
      return this.accountService.all;
    } else if  (key === 'crypto'){
      return this.accountService.getByType('CRYPTO');
    } else if  (key === 'clearjunction'){
      return this.accountService.getByType('CLEARJUNCTION');
    } else if  (key === 'custody'){
        return this.accountService.getByType('CUSTODY');
    }

    if (key === 'total'){
      if (!codeTo) {
        codeTo = 'EUR';
      }

      return this.accountService.totals[codeTo];
    }

    return this.accountService.getByCurrency(key);
  }
}
