import { Pipe, PipeTransform } from '@angular/core';
import { isEmpty } from '../Helper';
import { AccountService } from '../services/AccountService';
import Account from '../objects/Account';

@Pipe({ name: 'account', pure: false })
export class AccountPipe implements PipeTransform {
  constructor(private readonly accountService: AccountService) {
  }

  transform(key: number | string): Account {
    if (typeof key === 'string'){
      let accounts: Account[];

      if (key === 'all' || isEmpty(key)){
        accounts = this.accountService.all;
      } else {
        accounts = this.accountService.getByCurrency(key);
      }

      if (accounts.length < 1){
        return null;
      }

      return accounts[0];
    }

    return this.accountService.account(key);
  }
}
