import { Decimal as DecimalJS } from 'decimal.js';
import { TransactionService } from '../services/TransactionService';
import Account from './Account';

export default class Transaction {
  constructor(
    private service: TransactionService
  ) { }
  type: string;
  subType: string;
  id: number;
  accountToId?: number;
  accountFromId?: number;
  userId: number;
  number: string;
  transactionId: string;
  addressFrom?: string;
  addressTo?: string;
  amountTo?: number;
  amountFrom?: number;
  rate?: number;
  rateUsd?: number;
  rateEur?: number;
  currencyCodeFrom?: string;
  currencyCodeTo?: string;
  amountToEur?: number;
  amountToUsd?: number;
  amountFromEur?: number;
  amountFromUsd?: number;
  total: number;
  totalUsd: number;
  totalEur: number;
  systemFeePercent: number;
  systemFee: number;
  txFee: number;
  status: number;
  statusText?: string;
  note?: string;
  confirmed: boolean;
  createdDate?: Date;
  updatedDate?: Date;
  beneficiary?: string;
  iban?: string;
  detail?: any;

  public get account(): Partial<Account> {
    if (!this.service.accountService) {
      return { id: this.accountFromId };
    }
    return this.service.accountService.account(this.accountFromId);
  }

  public inRate(currencyCode: 'USD' | 'EUR' = 'EUR'): number{
    if (currencyCode === 'USD') {
      return new DecimalJS(this.amountFrom).times(this.rateUsd).toNumber();
    } else {
      return new DecimalJS(this.amountFrom).times(this.rateEur).toNumber();
    }
  }

  public get accountTo(): Partial<Account> {
    if (!this.accountToId) {
      return null;
    }
    if (!this.service.accountService) {
      return { id: this.accountToId };
    }
    return this.service.accountService.account(this.accountToId);
  }
}
