import { CurrencyRates, CurrencyRate } from '../types/CurrencyRates';
import { CurrencyService } from '../services/CurrencyService';

export class Currency {
  public code: string;
  public codeLabel: string;
  public name: string;
  public protocol: string;
  public symbol: string;
  public type: 'crypto' | 'fiat' | 'internal';
  readonly rates: CurrencyRates = {};
  readonly to: string[] = [];
  readonly from: string[] = [];

  constructor(private service: CurrencyService) { }

  public rate(to = 'EUR'): number {
    return this.exchange(to).rate || 0;
  }

  public fee(to = 'EUR'): number {
    return this.exchange(to).fee || 0;
  }

  public feePercent(to = 'EUR'): number {
    return this.exchange(to).feePercent || 0;
  }

  public exchange(to = 'EUR'): CurrencyRate {
    return this.rates[to] || { rate: 0, fee: 0, feePercent: 0 };
  }
  public dayDifferenceRate(to = 'EUR'): number {
    return this.exchange(to).dayChangeRate || 0;
  }

  public dayDifferencePercent(to = 'EUR'): number {
    return this.exchange(to).dayChangePercent || 0;
  }
}
