import { Decimal as DecimalJS } from 'decimal.js';
import { AccountService } from '../services/AccountService';
import { Currency } from './Currency';

export default class Account {
    public id: number;
    public currencyCode: string;
    public balance: number;
    public label: string;
    public type: string;
    public details: any[];

    constructor(
        private readonly accountService: AccountService
    ) { }


    public get currency(): Partial<Currency> {
        return this.accountService.currencyService.currency(this.currencyCode) || { code: this.currencyCode };
    }

    public rate(code = 'EUR'): number {
        if (!this.currency || !this.currency.rate) {
            return 0;
        }

        return new DecimalJS(this.balance).times(this.currency.rate(code)).toNumber();
    }
}
