import { Filter } from './types/filter';
import * as moment from 'moment';
import { DateRange } from './components/table-filter/TableFilterComponent';

export function filterGetQueryString(filters: Filter[]): string {
    // update filters
    let filtersString = '';

    for (const filter of filters) {
        if (filter.value == null) {
            continue;
        }

        let value: any = null;

        if (filter.value instanceof Date) {
            const date: Date = filter.value as Date;
            value = `${date.getFullYear()}-${date.getMonth() + 1}-${date.getDate()}`;
        } else {
            value = filter.value;
        }

        if (filtersString !== '') {
            filtersString += ';';
        }

        filtersString += filter.name + '=' + value;
    }

    return filtersString;
}

export function filterClear(filters: Filter[]): void {
    for (const filter of filters) {
        filter.value = null;
    }
}

export function getDateRange(period: string): any {
    let dateRange: DateRange = null;

    switch (period) {
        case '1d':
            return dateRange = {
                dateForm: moment().toDate(),
                dateTo: moment().toDate()
            };
        case '1w':
            return dateRange = {
                dateForm: moment().subtract(1, 'weeks').toDate(),
                dateTo: moment().toDate()
            };
        case '1m':
            return dateRange = {
                dateForm: moment().subtract(1, 'month').toDate(),
                dateTo: moment().toDate()
            };
        case '1y':
            return dateRange = {
                dateForm: moment().subtract(1, 'year').toDate(),
                dateTo: moment().toDate()
            };
        default:
            return dateRange = {
                dateForm: null,
                dateTo: null
            };
    }
}
