import { Directive, ElementRef, HostListener, Input } from '@angular/core';

// tslint:disable: deprecation
// tslint:disable: directive-selector

@Directive({
  selector: '[OnlyNumber]'
})
export class OnlyNumberDirective {
  @Input() OnlyNumber: boolean;

  constructor(private readonly el: ElementRef) {
  }

  @HostListener('keydown', ['$event']) onKeyDown(event): void {
    const e = event as KeyboardEvent;
    if (this.OnlyNumber) {
      if ([46, 8, 9, 27, 13, 110, 190].indexOf(e.keyCode) !== -1 ||
        (e.keyCode === 65 && e.ctrlKey === true) ||
        (e.keyCode === 67 && e.ctrlKey === true) ||
        (e.keyCode === 88 && e.ctrlKey === true) ||
        (e.keyCode >= 35 && e.keyCode <= 39)) {
          return;
        }
      if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
            e.preventDefault();
        }
      }
  }
}
