import { Component, Inject } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { HttpClient } from '@angular/common/http';
import { SwalService } from '@app/shared/services/SwalService';

@Component({
    selector: 'app-two-factor-auth-dialog',
    templateUrl: './two-factor-auth-dialog-component.html',
    styleUrls: ['./two-factor-auth-dialog-component.scss']
})
export class TwoFactorAuthDialogComponent {
    public form: FormGroup;

    constructor(
        public readonly dialogRef: MatDialogRef<TwoFactorAuthDialogComponent>,
        @Inject(MAT_DIALOG_DATA) public readonly data: any,
        private readonly formBuilder: FormBuilder,
        private readonly httpClient: HttpClient,
        private readonly swalService: SwalService
    ){
        this.form = this.formBuilder.group({
            code: [null, [Validators.required, Validators.pattern(/^\d{6}$/)]]
        });
    }

    public onConfirm(): void {
        if (this.form.invalid) {
            return;
        }

        const formData: any = {
            authenticatorCode: this.form.get('code').value,
        };

        this.dialogRef.close(formData);
    }

    public close(): void {
        this.dialogRef.close();
    }
}
