import { Decimal as DecimalJS } from 'decimal.js';
import { SelectionModel } from '@angular/cdk/collections';
import { Component, Input } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { MatTableDataSource } from '@angular/material/table';
import { Payment } from '@app/shared/types/Payment';
import { DialogComponent } from '../../dialog-component/DialogComponent';

@Component({
  selector: 'app-transaction-statement-table',
  templateUrl: 'transaction-statement-table-component.html',
  styleUrls: ['./transaction-statement-table-component.scss'],
})
export class TransactionStatementTableComponent {
  public count: number;
  public selection = new SelectionModel<any>(true, []);
  private readonly networkFeeLabels: { [type: string]: string } = {
    SOON_AS_POSSIBLE: 'Soon as possible',
    REGULAR: 'Regular'
  };

  @Input() public dataSource: MatTableDataSource<Payment>;
  @Input() public displayedColumns: string[];

  constructor(
    private readonly matDialog: MatDialog
  ) {
  }

  public openTransactionDetails(payment: Payment): void {
    this.matDialog.open(DialogComponent, {
      data: {
        type: 'confirmTransaction',
        header: 'Transactions Details',
        content: [
          {label: 'Notes', value: payment.note},
          {label: 'Reference number', value: `WD433${payment.id}`},
          {label: 'Creation date', value: payment.created, type: 'date'},
          {label: 'System fee', value: new DecimalJS(payment.systemFee).toDecimalPlaces(8).toNumber()},
          {label: 'Completion date', value: payment.created, type: 'date'},
          {label: 'Network fee type', value: this.networkFeeLabels[payment.networkFeeType]},
          // {label: 'Transaction fee', value: payment.transactionFee, percentage: transaction.transactionFeePerc, type: 'number'},
          // {label: 'Transaction ID', value: payment.paymentId},
          {label: 'Total amount charged', value: new DecimalJS(payment.total).toDecimalPlaces(8).toNumber()},
          {label: 'Address to', value: payment.address},
        ],
      },
      width: '55rem',
    });
  }

  public confirmTransaction(transaction: any): void {
  }

  isAllSelected(): boolean {
    const numSelected = this.selection.selected.length;
    const numRows = this.dataSource.data.length;
    return numSelected === numRows;
  }

  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'select' : 'deselect'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row.position + 1}`;
  }

  downloadReport(type: string): void {
    if (this.selection.selected.length === 0) {
      return;
    }

    if (type === 'pdf') {
      const ids = this.selection.selected.join(',');
    }
  }
}
