import { Component, Input } from '@angular/core';
import { MediaObserver } from '@angular/flex-layout';
import { MatDialog } from '@angular/material/dialog';
import { DialogComponent } from '../../dialog-component/DialogComponent';
import { TicketTableData } from '@app/pages/support/SupportComponent';

@Component({
  selector: 'app-ticket-table',
  templateUrl: 'ticket-table-component.html',
  styleUrls: ['./ticket-table-component.scss'],
})
export class TicketTableComponent {
  public displayedColumns: string[] = [
    'id',
    'date',
    'subject',
    'status',
    'details'
  ];

  @Input() public dataSource: any;

  constructor(
    private media: MediaObserver,
    private dialog: MatDialog
  ) {
  }

  public openDetails(ticket: TicketTableData): void {
    const dialogRef = this.dialog.open(DialogComponent, {
      data: {
        type: 'ticketDetails',
        header: 'Ticket details',
        content: {
          subject: ticket.subject,
          messages: ticket.messages,
          status: ticket.status,
          createdDate: ticket.createdDate
        },
      },
      width: '60rem',
    });
  }
}
