import { Component, Input } from '@angular/core';
import { MediaObserver } from '@angular/flex-layout';
import { MatDialog } from '@angular/material/dialog';

@Component({
  selector: 'app-pending-table',
  templateUrl: 'pending-table-component.html',
  styleUrls: ['./pending-table-component.scss'],
})

export class PendingTableComponent {

  public displayedColumns: string[] = [
    'icon',
    'assetType',
    'accountName',
    'settings',
  ];

  @Input() public dataSource: any;

  constructor(
    private readonly media: MediaObserver,
    private readonly dialog: MatDialog
  ) {
  }

  get isMobile(): boolean {
    return this.media.isActive('xs') || this.media.isActive('sm');
  }

  public confirm(e: any): void {
  }

  public approve(e: any): void {
  }
}
