import { Component, EventEmitter, Input, OnInit, Output, ViewChild } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { filterClear, getDateRange } from '@app/shared/filter.helper';
import { FormFieldDesign } from '@app/shared/types/FormFieldDesign';
import * as moment from 'moment';
import { DaterangepickerDirective } from 'ngx-daterangepicker-material';

interface Period {
  label?: string;
  period?: string;
}

export interface DateRange {
  dateForm?: Date;
  dateTo?: Date;
}

@Component({
  selector: 'app-table-filter',
  templateUrl: './table-filter-component.html',
  styleUrls: ['./table-filter-component.scss'],
})
export class TableFilterComponent implements OnInit {
  public filterOpen = false;
  public selectedDateRange: string = null;
  public selectedPeriod = 'All';
  public currentDate = moment();
  public showDateFilters = false;

  public design: FormFieldDesign = {
    header: 'no-field',
    field: 'stroked',
  };

  public totalPeriods: Period[] = [
    { label: 'Day', period: '1d' },
    { label: 'Week', period: '1w' },
    { label: 'Month', period: '1m' },
    { label: 'Year', period: '1y' },
    { label: 'All', period: null },
  ];

  @ViewChild(DaterangepickerDirective) pickerDirective: DaterangepickerDirective;
  @Output() searchEvent = new EventEmitter();
  @Input() public tableHeader: string;
  @Input() public filters: any[] = null;
  @Input() public formGroup: FormGroup;

  ngOnInit(): void {
    this.showDateFilters = this.formGroup.get('dateFrom') && this.formGroup.get('dateTo') ? true : false;
  }

  public clearSearch(): void {
    filterClear(this.filters);
    this.searchEvent.emit();
    this.selectedPeriod = 'All';
    this.selectedDateRange = null;
  }

  public open(e: any): void {
    console.log(e);
    this.pickerDirective.open(e);
  }

  public dateChange(e: any): void {
    if (e.startDate === null || !e.startDate) {
      return;
    }

    this.selectedPeriod = 'dateRange';
    this.setDateRange(e.startDate._d, e.endDate._d);
  }

  public changeFilterDate(period: Period): void {
    if (!period) {
      return;
    }

    this.selectedDateRange = null;
    this.selectedPeriod = period.label;

    const dateRage = getDateRange(period.period);
    this.setDateRange(dateRage.dateForm, dateRage.dateTo);
  }

  public setDateRange(dateFrom: Date, dateTo: Date): void {
    this.formGroup.get('dateFrom').setValue(dateFrom);
    this.formGroup.get('dateTo').setValue(dateTo);
    this.searchEvent.emit();
  }
}
