import { Component, Input, Output, EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { MatSelectChange } from '@angular/material/select';
import { FormFieldDesign } from '@app/shared/types/FormFieldDesign';

export interface SelectType {
  tooltip?: string;
  header?: string;
  bold?: boolean;
  options: { viewValue: string, value: string }[];
}
@Component({
  selector: 'app-select-component',
  templateUrl: './select-component.html',
  styleUrls: ['./select-component.scss'],
})
export class SelectComponent {
  @Input() public content: SelectType;
  @Input() public formGroup: FormGroup;
  @Input() public controlName: string;
  @Input() public design: FormFieldDesign;
  @Output() private selectEvent = new EventEmitter();

  public onSelectChange(event: MatSelectChange): void {
    this.selectEvent.emit(event.value);
  }
}
