import { Component, OnInit, Inject } from '@angular/core';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { ZXingScannerComponent } from '@zxing/ngx-scanner';

@Component({
  selector: 'app-qr-scanner-dialog',
  templateUrl: './qr-scanner-component.html',
  styleUrls: ['./qr-scanner-component.scss']
})
export class QrScannerDialogComponent implements OnInit{

  public coins = [
    {currency: 'BTC', uri: 'bitcoin:', regex: /^[13][a-km-zA-HJ-NP-Z0-9]{26,33}$/},
    {currency: 'DASH', uri: 'dash:', regex: /^X[1-9A-HJ-NP-Za-km-z]{33}/},
    {currency: 'ETH', uri: 'ethereum:', regex: /^0x[a-fA-F0-9]{40}$/},
    {currency: 'LTC', uri: 'litecoin:', regex: /^[LM3][a-km-zA-HJ-NP-Z1-9]{26,33}$/}
  ];

  public invalidWallet = false;
  public length = 0;
  public availableCameras: any;
  public noCamerasFound = false;
  public selectedCamera = null;

  scanner: ZXingScannerComponent;

  constructor(
    private dialogRef: MatDialogRef<QrScannerDialogComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
  ) { }

  ngOnInit(): void {
    // console.log(this.data.currencyCode);
  }

  close(data?: any): void {
    this.dialogRef.close(data);
  }

  public getQRCode(code: string): void {
    code = code.trim();

    // Check if it is URI
    // TODO: Rework
    let foundCoin = null;
    for (const coin of this.coins) {
      if (code.startsWith(coin.uri)) {
        if (this.data.currencyCode !== coin.currency) {
          continue;
        }

        foundCoin = coin;
        break;
      }
    }

    if (foundCoin) {
      try {
        const uri = new URL(code);

        if (foundCoin.regex.test(uri.pathname)) {
          this.close({
            coin: foundCoin.currency,
            address: uri.pathname,
            amount: uri.searchParams.get('amount'),
            note: uri.searchParams.get('message')
          });

          return;
        }
      } catch (err) {
        console.error('Invalid URI format!');
      }
    }

    // TODO: Rework
    for (const coin of this.coins) {
      if (coin.regex.test(code)) {
        if (this.data.currencyCode !== coin.currency) {
          continue;
        }

        this.close({
          coin: coin.currency,
          address: code,
          amount: null,
          note: null
        });
        return;
      }
    }
    this.invalidWallet = true;
  }

  public getCameras(cameras: any): void {
    this.availableCameras = cameras;
    if (this.availableCameras && this.availableCameras.length > 0) {
        this.selectedCamera = this.availableCameras[0];
    }
    console.log('Cameras: ', this.availableCameras, this.selectedCamera);
  }

  public errorCamera(event: any): void {
    this.noCamerasFound = true;
    console.log('error camera not found', event);
  }
}
