import { Component, Inject } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';

@Component({
    selector: 'app-otp-auth-dialog',
    templateUrl: './otp-auth-dialog-component.html',
    styleUrls: ['./otp-auth-dialog-component.scss']
})
export class OtpAuthDialogComponent {
    public form: FormGroup;

    constructor(
        public readonly dialogRef: MatDialogRef<OtpAuthDialogComponent>,
        private readonly formBuilder: FormBuilder,
        @Inject(MAT_DIALOG_DATA) public readonly data: any
    ){
        this.form = this.formBuilder.group({
            password: [
                null,
                [Validators.required]
            ]
        });
    }

    public onConfirm(): void {
        if (this.form.invalid) {
            return;
        }

        const formData: any = {
            otpAuthPassword: this.form.get('password').value
        };

        this.dialogRef.close(formData);
    }

    public close(): void {
        this.dialogRef.close();
    }
}
