import { Component, Inject } from '@angular/core';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { FormControlObject } from '../../../shared/types/FormFieldObject';
import { FormFieldDesign } from '../../../shared/types/FormFieldDesign';
import { HttpClient } from '@angular/common/http';

@Component({
  selector: 'app-invite-code-dialog',
  templateUrl: './invite-code-dialog.html',
  styleUrls: ['./invite-code-dialog.scss'],
})
export class InviteCodeDialogComponent {
  public formGroup: FormGroup;
  public field: FormControlObject = { label: 'Invitation code', formControlName: 'inviteCode' };
  public design: FormFieldDesign = {
    header: 'no-bold',
    field: 'stroked',
  };
  constructor(
    public dialog: MatDialogRef<InviteCodeDialogComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private formBuilder: FormBuilder,
    private httpClient: HttpClient
  ) {
    this.formGroup = this.formBuilder.group({
      inviteCode: [null, Validators.required],
    });
  }

  public confirmInviteCode(): void {
    if (
      this.formGroup.invalid ||
      this.formGroup.get('inviteCode').value === null ||
      this.formGroup.get('inviteCode').value === ''
    ) {
      return;
    }

    const inviteCode: string = this.formGroup.get('inviteCode').value;

    // Validate invitation code
    this.httpClient.get<any>('/user/invitation/verify/' + inviteCode).subscribe((res: { status: boolean}) => {
      if (res && res.status === true) {
        this.close(inviteCode);
      } else {
        this.formGroup.get('inviteCode').setErrors({ incorrect: true });
      }
    });
  }

  public close(code: string): void {
    this.dialog.close(code);
  }
}
