import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { Observable } from 'rxjs';
import { FormGroup } from '@angular/forms';
import { FormFieldDesign } from '../../../types/FormFieldDesign';
import { map, startWith } from 'rxjs/operators';
import { CallingCodes } from './callingCodes';

// tslint:disable: deprecation

export interface FormControlObjectPhoneNumber {
  formControlName: string;
  formControlNameCallCode: string;
  label: string;
  suffix?: {
    type: string;
    icon?: string;
    text?: string;
  };
}

@Component({
  selector: 'app-input-phone-number',
  templateUrl: 'phone-number-input-field-component.html',
  styleUrls: ['./phone-number-input-field-component.scss'],
})
export class PhoneNumberInputFieldComponent implements OnInit {
  public filteredCallingCodes: Observable<string[]>;
  public callingCodes: string[] = [];
  private localCodes = CallingCodes;

  @Input() public formControlObject: FormControlObjectPhoneNumber;
  @Input() public formGroup: FormGroup;
  @Input() public design: FormFieldDesign;

  @Output() stateChange = new EventEmitter();
  @Output() keyUpEvent = new EventEmitter();

  ngOnInit(): void {
    this.filteredCallingCodes = this.formGroup.get(this.formControlObject.formControlNameCallCode).valueChanges
      .pipe(
        startWith(null),
        map(value => this._filter(parseInt(value, 10), this.callingCodes))
      );

    // gets codes without dupes
    for (const code of this.localCodes) {
      if (this.callingCodes.includes(code) !== true) {
        this.callingCodes.push(code);
      }
    }
  }

  //
  // Filters calling code list that aligns with input
  //
  private _filter(value: number, unfilteredArray: string[]): string[] {
    if (!value || typeof value !== 'number') {
      return unfilteredArray;
    }

    return unfilteredArray.filter((option: any) => {
      if (typeof (value) === 'number') {
        if (value <= 9) {
          return option.startsWith(value);
        } else {
          return option.includes(value);
        }
      }
    });
  }

  // TODO: Naming
  public getCallCode(phoneNumber: any): void {
    if (this.callingCodes.includes(phoneNumber) === true) {
      this.formGroup.get(this.formControlObject.formControlNameCallCode).setErrors(null);
      this.formGroup.get(this.formControlObject.formControlNameCallCode).setValue(phoneNumber);
      this.formGroup.get(this.formControlObject.formControlNameCallCode).markAsUntouched();
      return;
    } else {
      this.formGroup.get(this.formControlObject.formControlNameCallCode).setErrors({ required: true });
      this.formGroup.get(this.formControlObject.formControlNameCallCode).markAsTouched();
    }
  }
}
