import { Component, Input, Output, EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { FormControlObject } from '../../../types/FormFieldObject';
import { FormFieldDesign } from '../../../types/FormFieldDesign';

@Component({
  selector: 'app-input-password',
  templateUrl: 'password-input-field-component.html',
  styleUrls: ['./password-input-field-component.scss'],
})
export class PasswordInputFieldComponent {
  public hide = true;

  @Input() public formControlObject: FormControlObject;
  @Input() public formGroup: FormGroup;
  @Input() public design: FormFieldDesign;

  @Output() stateChange = new EventEmitter();

  public submit(): void {
    this.stateChange.emit('submitForm');
  }
}
