import { Component, Input, Output, EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { FormControlObject } from '../../../types/FormFieldObject';
import { FormFieldDesign } from '../../../types/FormFieldDesign';

@Component({
  selector: 'app-input-number',
  templateUrl: 'number-input-field-component.html',
  styleUrls: ['./number-input-field-component.scss'],
})
export class NumberInputFieldComponent {
  @Input() public formControlObject: FormControlObject;
  @Input() public formGroup: FormGroup;
  @Input() public design: FormFieldDesign;

  @Output() stateChange = new EventEmitter();
  @Output() keyUpEvent = new EventEmitter();

  public keyUp(value: number): void {
    this.keyUpEvent.emit(value);
  }
}
