import { Component, Input, Output, EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { FormControlObject } from '../../../types/FormFieldObject';
import { FormFieldDesign } from '../../../types/FormFieldDesign';

@Component({
  selector: 'app-input-date',
  templateUrl: 'date-input-field-component.html',
  styleUrls: ['./date-input-field-component.scss'],
})
export class DateInputFieldComponent {
  public startDate = new Date(1990, 0, 1);

  @Input() public formControlObject: FormControlObject;
  @Input() public formGroup: FormGroup;
  @Input() public design: FormFieldDesign;
  @Output() stateChange = new EventEmitter();
}
