import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { FormControlObject } from '../../../types/FormFieldObject';
import { FormFieldDesign } from '../../../types/FormFieldDesign';
import * as countries from 'i18n-iso-countries';
import { Observable } from 'rxjs';
import { map, startWith } from 'rxjs/operators';

@Component({
  selector: 'app-input-country',
  templateUrl: 'country-input-field-component.html',
  styleUrls: ['./country-input-field-component.scss'],
})
export class CountryInputFieldComponent implements OnInit {
  public countries: string[] = [];
  public filteredCountries: Observable<string[]>;

  @Input() public formControlObject: FormControlObject;
  @Input() public formGroup: FormGroup;
  @Input() public design: FormFieldDesign;
  @Output() stateChange = new EventEmitter();

  ngOnInit(): void {
    countries.registerLocale(require('i18n-iso-countries/langs/en.json'));

    // gets country
    // tslint:disable-next-line: forin
    for (const key in countries.getNames('en')) {
      const countryName: any = countries.getNames('en')[key];
      if (countryName.constructor === Array){
        countryName.forEach(country => {
          this.countries.push(country);
        });
      }
      this.countries.push(countryName);
    }

    this.filteredCountries = this.formGroup.get(this.formControlObject.formControlName).valueChanges.pipe(
      startWith(''),
      map(value => this._filter(value, this.countries))
    );
  }

  //
  // Filters country list that aligns with input
  //
  private _filter(value: any, unfilteredArray: string[]): string[] {
    if (!value || typeof value !== 'string') {
      return unfilteredArray;
    }

    return unfilteredArray.filter((option: string) => {
      if (typeof option !== 'string'){
        return false;
      }

      return option.toLowerCase().includes(value.toLowerCase());
    });
  }

  //
  // TODO: Naming
  // Sets validation
  //
  public getCountryCode(country: any): void {
    if (!countries.getAlpha2Code(country, 'en')) {
      this.formGroup.get(this.formControlObject.formControlName).hasError('required');
      this.formGroup.get(this.formControlObject.formControlName).markAsTouched();
    } else {
      this.formGroup.get(this.formControlObject.formControlName).setValue(country);
      this.formGroup.get(this.formControlObject.formControlName).markAsUntouched();
    }
  }
}
