import { Component, OnInit, Input } from '@angular/core';
import { DialogComponent } from '../../DialogComponent';
import { MatDialogRef } from '@angular/material/dialog';
import { FormGroup, FormBuilder } from '@angular/forms';
import { FormFieldDesign } from '@app/shared/types/FormFieldDesign';

@Component({
  selector: 'app-ticket-details-content',
  templateUrl: './ticket-details-content.html',
  styleUrls: ['./ticket-details-content.scss'],
})
export class TicketDetailsContentComponent implements OnInit {
  public displayedColumns = ['subject', 'status', 'createdDate'];
  public chatDisplayedColumns = ['author', 'message', 'createdMessageDate'];
  public ticketData: any = [];
  public chatData: any = [];
  public formGroup: FormGroup;

  public formFields = [
    { label: 'Send a message', formControlName: 'message', type: 'textarea' },
  ];

  public design: FormFieldDesign = {
    header: 'no-bold',
    field: 'stroked'
  };

  @Input() public content: any;

  constructor(public dialog: MatDialogRef<DialogComponent>, private formBuilder: FormBuilder) {
    this.formGroup = this.formBuilder.group({
      message: []
    });
  }

  ngOnInit(): void {
    this.ticketData = [
      {subject: this.content.subject, status: this.content.status, date: this.content.createdDate}
    ];

    this.chatData = this.content.messages;
  }

  public uploadImage(e: any): void {
  }

  public sendMessage(): void {
  }

  public close(): void {
    this.dialog.close();
  }
}
