import { Component, Input } from '@angular/core';
import { DialogComponent } from '../../DialogComponent';
import { MatDialogRef } from '@angular/material/dialog';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';

@Component({
    selector: 'app-recovery-phone-edit-content',
    templateUrl: './recovery-phone-edit-content.html',
    styleUrls: ['./recovery-phone-edit-content.scss']
})
export class RecoveryPhoneEditContentComponent {
    public form: FormGroup;
    public step = 1;

    @Input() public content: any;

    constructor(
        public readonly dialog: MatDialogRef<DialogComponent>,
        private readonly formBuilder: FormBuilder
    ) {
        this.form = this.formBuilder.group({
            phone: ['', Validators.email]
        });
    }

    public close(): void {
        this.dialog.close();
    }

    public confirmPhone(): void {
        console.log(this.form.get('email').value);
        this.step += 1;
    }

    public confirmCode(): void {
        // TODO: Impl
    }

    public resendCode(): void {
        // TODO: Impl
    }
}
