import { Component, Input } from '@angular/core';
import { DialogComponent } from '../../DialogComponent';
import { MatDialogRef } from '@angular/material/dialog';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { FormControlObject } from '@app/shared/types/FormFieldObject';
import { FormFieldDesign } from '@app/shared/types/FormFieldDesign';

@Component({
    selector: 'app-recovery-phone-add-content',
    templateUrl: './recovery-phone-add-content.html',
    styleUrls: ['./recovery-phone-add-content.scss']
})
export class RecoveryPhoneAddContentComponent {
    public form: FormGroup;
    public step = 1;

    @Input() public content: any;

    public fields: FormControlObject[] = [
        {formControlName: 'phone', label: 'Phone'},
        {formControlName: 'twoAuthCode', label: 'Authentication code'}
    ];

    public design: FormFieldDesign = {
        header: 'no-bold',
        field: 'stroked'
    };

    constructor(
        public readonly dialog: MatDialogRef<DialogComponent>,
        private readonly formBuilder: FormBuilder
    ){
        this.form = this.formBuilder.group({
            phone: ['', Validators.required],
            twoAuthCode: []
        });
    }

    public close(): void {
        this.dialog.close();
    }

    public confirmPhone(): void {
        const phone = this.form.get('phone').value;
        console.log(phone);

        this.step += 1;
    }

    public confirmCode(): void {
        // TODO: Impl
    }
    public resendCode(): void {
        // TODO: Impl
    }
}
