import { Component, Input } from '@angular/core';
import { DialogComponent } from '../../DialogComponent';
import { MatDialogRef } from '@angular/material/dialog';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';

@Component({
    selector: 'app-recovery-email-edit-content',
    templateUrl: './recovery-email-edit-content.html',
    styleUrls: ['./recovery-email-edit-content.scss']
})
export class RecoveryEmailEditContentComponent {
    public form: FormGroup;
    public step = 1;

    @Input() public content: any;

    constructor(
        public readonly dialog: MatDialogRef<DialogComponent>,
        private readonly formBuilder: FormBuilder
    ){
        this.form = this.formBuilder.group({
            email: ['', Validators.email]
        });
    }

    public close(): void {
        this.dialog.close();
    }

    public confirmEmail(): void {
        console.log(this.form.get('email').value);
        this.step += 1;
    }

    public confirmCode(): void {
        // TODO: Impl
    }
    public resendCode(): void {
        // TODO: Impl
    }
}
