import { Component, Input } from '@angular/core';
import { DialogComponent } from '../../DialogComponent';
import { MatDialogRef } from '@angular/material/dialog';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { FormControlObject } from '@app/shared/types/FormFieldObject';
import { FormFieldDesign } from '@app/shared/types/FormFieldDesign';

@Component({
    selector: 'app-recovery-email-add-content',
    templateUrl: './recovery-email-add-content.html',
    styleUrls: ['./recovery-email-add-content.scss']
})
export class RecoveryEmailAddContentComponent {
    public form: FormGroup;
    public step = 1;

    @Input() public content: any;

    public fields: FormControlObject[] = [
        {formControlName: 'email', label: 'Email'},
        {formControlName: 'twoAuthCode', label: 'Authentication code'}
    ];

    public design: FormFieldDesign = {
        header: 'no-bold',
        field: 'stroked'
    };

    constructor(
        public readonly dialog: MatDialogRef<DialogComponent>,
        private readonly formBuilder: FormBuilder
    ){
        this.form = this.formBuilder.group({
            email: ['', Validators.email],
            twoAuthCode: []
        });
    }

    public close(): void {
        this.dialog.close();
    }

    public confirmEmail(): void {
        const email = this.form.get('email').value;
        console.log(email);
        this.step += 1;
    }

    public confirmCode(): void {
        // TODO: Impl
    }
    public resendCode(): void {
        // TODO: Impl
    }
}
