import { Component, Input } from '@angular/core';
import { DialogComponent } from '../../DialogComponent';
import { MatDialogRef } from '@angular/material/dialog';
import { ClipboardService } from 'ngx-clipboard';

@Component({
    selector: 'app-receive-amount-content',
    templateUrl: './receive-amount-content.html',
    styleUrls: ['./receive-amount-content.scss']
})
export class ReceiveAmountContentComponent {
    @Input() public content: any;

    constructor(
        public readonly dialog: MatDialogRef<DialogComponent>,
        private readonly clipboardService: ClipboardService,
    ){
    }

    public close(): void {
        this.dialog.close();
    }

    public copy(text: string): void {
        this.clipboardService.copyFromContent(text);
    }
}
