import { Component, Input } from '@angular/core';
import { DialogComponent } from '../../DialogComponent';
import { MatDialogRef } from '@angular/material/dialog';
import { FormControl, FormGroup, FormBuilder, Validators } from '@angular/forms';
import { FormControlObject } from '@app/shared/types/FormFieldObject';
import { FormFieldDesign } from '@app/shared/types/FormFieldDesign';

@Component({
    selector: 'app-enable-two-factor-content',
    templateUrl: './enable-two-factor-content.html',
    styleUrls: ['./enable-two-factor-content.scss']
})
export class EnableTwoFactorContentComponent {
    @Input() public content: any;

    public form: FormGroup;
    public basicAuth: FormGroup;
    public step = 1;
    public hide = true;

    public fields: FormControlObject[] = [
        {formControlName: 'email', label: 'Email'},
        {formControlName: 'password', label: 'Password'},
        {formControlName: 'code', label: 'Enter 6-digit code'}
    ];

    public design: FormFieldDesign = {
        header: 'no-bold',
        field: 'stroked'
    };

    constructor(
        public readonly dialog: MatDialogRef<DialogComponent>,
        private readonly formBuilder: FormBuilder
    ) {
        this.basicAuth = this.formBuilder.group({
            email: ['', [Validators.email, Validators.required]],
            password: ['', Validators.required]
        });
        this.form = this.formBuilder.group({
            code: ['', Validators.required]
        });
    }

    public close(): void {
        this.dialog.close();
    }

    public confirmCode(): void {
        console.log(this.form.get('code').value);
    }

    public authorize(): void {
        this.step += 1;
    }
}
