import { WalletTypes } from '@app/shared/constant/WalletTypes';
import { AssetTypes } from './../../../../constant/AssetTypes';
import { HttpClient } from '@angular/common/http';
import { Component } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef } from '@angular/material/dialog';
import { Logger } from '@app/core/LoggerService';
import { SelectType } from '@app/shared/components/select-component/SelectComponent';
import { SwalService } from '@app/shared/services/SwalService';
import { FormFieldDesign } from '@app/shared/types/FormFieldDesign';
import { DialogComponent } from '../../DialogComponent';

@Component({
  selector: 'app-create-wallet-component',
  templateUrl: './create-wallet-component.html',
  styleUrls: ['./create-wallet-component.scss'],
})
export class CreateWalletComponent {
  private readonly logger = new Logger(CreateWalletComponent.name);

  public formGroup: FormGroup;
  public step = 1;
  public walletName = {
    label: 'Wallet name',
    formControlName: 'walletName',
  };

  public selectLayout: SelectType[] = [
    {
      header: 'Wallet type',
      tooltip: 'Wallet type',
      options: WalletTypes
    },
    {
      header: 'Asset type',
      options: AssetTypes
    },
    {
      header: 'Asset',
      options: [
        { viewValue: 'Bitcoin', value: 'BTC' },
        { viewValue: 'Ethereum', value: 'ETH' },
        { viewValue: 'Dash', value: 'DASH' },
        { viewValue: 'Litecoin', value: 'LTC' },
      ],
    },
  ];

  public design: FormFieldDesign = {
    header: 'no-bold',
    field: 'stroked'
  };

  constructor(
    public dialog: MatDialogRef<DialogComponent>,
    private readonly formBuilder: FormBuilder,
    private readonly httpClient: HttpClient,
    private readonly swalService: SwalService
  ) {
    this.formGroup = this.formBuilder.group({
      walletName: [null, Validators.required],
      walletType: [{ value: 'private', disabled: true }, Validators.required],
      assetType: [{ value: 'crypto', disabled: true }, Validators.required],
      dltType: ['btc', Validators.required],
    });
  }

  // TODO: What is 'e'?
  public close(e?: string): void {
    this.dialog.close(e);
  }

  public createWallet(): void {
    if (this.formGroup.invalid) {
      return;
    }

    const formData: {label: string, description: string, currencyCode: string, walletType: string, assetType: string} = {
      label: this.formGroup.get('walletName').value,
      description: '',
      currencyCode: this.formGroup.get('dltType').value,
      walletType: this.formGroup.get('walletType').value,
      assetType: this.formGroup.get('assetType').value,
    };

    this.httpClient.post('/wallet', formData).subscribe((WalletDto: any) => {
      if (WalletDto){
        this.close('walletSuccess');
      }
    }, (err) => {
      this.logger.error('Can\'t create wallet', err.stack);
      this.swalService.showError({ title: 'Error', text: 'Couldn\'t create wallet'});
    });
  }

  public confirmWallet(): void {
    if (this.formGroup.invalid) {
      return;
    }

    this.step += 1;
  }

  public back(): void {
    this.step -= 1;
  }
}
