import { Component } from '@angular/core';
import { DialogComponent } from '../../DialogComponent';
import { MatDialogRef } from '@angular/material/dialog';
import { SelectType } from '../../../select-component/SelectComponent';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { FormFieldDesign } from '../../../../types/FormFieldDesign';
import { HttpClient } from '@angular/common/http';
import { SwalService } from '../../../../services/SwalService';
import { Logger } from '../../../../../core/LoggerService';

@Component({
  selector: 'app-create-vault-content',
  templateUrl: './create-vault-content.html',
  styleUrls: ['./create-vault-content.scss'],
})
export class CreateVaultContentComponent {
  private readonly logger = new Logger(CreateVaultContentComponent.name);

  public formGroup: FormGroup;
  public step = 1;
  public walletDetail: any;
  public walletName = {
    label: 'Vault name',
    formControlName: 'vaultName',
  };
  public selectLayout: SelectType =
    {
      header: 'Asset',
      options: [
        { viewValue: 'Bitcoin', value: 'btc' },
        { viewValue: 'Ethereum', value: 'eth' },
        { viewValue: 'Dash', value: 'dash' },
        { viewValue: 'Litecoin', value: 'ltc' },
      ],
    };

  public design: FormFieldDesign = {
    header: 'no-bold',
    field: 'stroked'
  };

  constructor(
    public dialog: MatDialogRef<DialogComponent>,
    private readonly formBuilder: FormBuilder,
    private readonly httpClient: HttpClient,
    private readonly swalService: SwalService
  ) {
    this.formGroup = this.formBuilder.group({
      vaultName: [null, Validators.required],
      dltType: [null, Validators.required],
    });
  }

  public close(e?: string): void {
    this.dialog.close(e);
  }

  public createVault(): void {
    if (this.formGroup.invalid) {
      return;
    }

    const formData: { label: string, currencyCode: string} = {
      label: this.formGroup.get('vaultName').value,
      currencyCode: this.formGroup.get('dltType').value,
    };

    this.httpClient.post('/vault', formData).subscribe((VaultdTo: any) => {
      if (VaultdTo) {
        this.close('vaultSuccess');
      }
    },
    (err) => {
      this.logger.error('Can"t create vault request', err.stack);
      this.swalService.showError({ title: 'Error', text: 'Couldn\'t create vault request' });
    });
  }

  public confirmVault(): void {
    if (this.formGroup.invalid) {
      return;
    }

    this.walletDetail = {
      walletName: this.formGroup.get('vaultName').value,
      dltType: this.selectLayout.options.find(x => x.value === this.formGroup.get('dltType').value).viewValue,
    };

    this.step += 1;
  }

  public selectHandler(event: any, select: any): void {
    this.formGroup.get(select.id).setValue(event);
  }
}
