import { Component, Inject, OnInit } from '@angular/core';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';

@Component({
    selector: 'app-dialog-component',
    templateUrl: './dialog-component.html',
    styleUrls: ['./dialog-component.scss']
})
export class DialogComponent implements OnInit {
    constructor(
        public readonly dialogRef: MatDialogRef<DialogComponent>,
        @Inject(MAT_DIALOG_DATA) public readonly data: any,
    ){
    }

    ngOnInit(): void {
        this.readyDialog(this.data.type);
    }

    //
    // For data formatting if needed
    //
    private readyDialog(type: string): void {
        switch (type) {
            case 'enable2FA':
                break;
            case 'recoveryEmail':
                break;
        }
    }

    public close(): void {
        this.dialogRef.close();
    }
}
