import { Component, OnInit, Input, EventEmitter, Output, OnDestroy } from '@angular/core';
import { FormControl } from '@angular/forms';
import { Subscription } from 'rxjs';

export interface CheckBoxWithStatus {
    name: string;
    status: any;
    tooltip?: string;
    formControl: FormControl;
    formControlName: string;
}

@Component({
    selector: 'app-checkbox-status',
    templateUrl: './checkbox-status-component.html',
    styleUrls: ['./checkbox-status-component.scss']
})
export class CheckboxStatusComponent implements OnInit, OnDestroy {
    @Input() public content: CheckBoxWithStatus;
    @Output() stateChange = new EventEmitter();
    public checkboxFormControlSubscription: Subscription;

    public status: string;

    // TODO: is this OK?
    public statusTypes = {
        PENDING_WAITING: 'pending',
        PENDING: 'pending',
        APPROVED: 'approved',
    };

    ngOnInit(): void {
        this.status = this.statusTypes[this.content.status];
        this.checkboxFormControlSubscription = this.content.formControl.valueChanges.subscribe(val => {
            this.stateChange.emit(val);
            this.status = this.statusTypes[this.content.status];
        });
    }

    ngOnDestroy(): void {
        if (this.checkboxFormControlSubscription) {
            this.checkboxFormControlSubscription.unsubscribe();
        }
    }
}
