import { Component, Inject } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';

@Component({
    selector: 'app-basic-auth-dialog',
    templateUrl: './basic-auth-dialog.html',
    styleUrls: ['./basic-auth-dialog.scss']
})
export class BasicAuthDialogComponent {
    public form: FormGroup;

    constructor(
        public dialogRef: MatDialogRef<BasicAuthDialogComponent>,
        @Inject(MAT_DIALOG_DATA) public data: any,
        private formBuilder: FormBuilder
    ) {
        this.form = this.formBuilder.group({
            email: ['', [Validators.required, Validators.email]],
            password: ['', Validators.required],
            remember: true
        });
    }

    public onConfirm(): void {
        if (this.form.invalid) {
            return;
        }

        const formData: any = {
            basicAuthEmail: this.form.get('email').value,
            basicAuthPassword: this.form.get('password').value
        };

        this.dialogRef.close(formData);
    }

    public onClose(): void {
        this.dialogRef.close();
    }
}
