import { FormGroup, FormControl } from '@angular/forms';
import { Component, OnInit, Output, EventEmitter } from '@angular/core';
// import { AddAddressbookDialogComponent } from "../add-addressbook-dialog/AddAddressbookDialogComponent";
// import { ConfirmAddressbookDialogComponent } from "../confirm-addressbook-dialog/ConfirmAddressbookDialogComponent";

@Component({
  selector: 'app-addressbook',
  templateUrl: './address-book-component.html',
  styleUrls: ['./address-book-component.scss']
})
export class AddressBookComponent implements OnInit {
  public addressFilter = new FormControl();
  public form: FormGroup;
  public sortedAddressBook: any = [];
  public contacts: any = [];

  @Output() public contactSelected: EventEmitter<any> = new EventEmitter<any>();

  public openAddAddressBookDialog(): void {
    // const dialogRef = this.dialog.open(AddAddressbookDialogComponent, {
    //   data: { page: this.page },
    //   width: '50rem'
    // });

    // dialogRef.afterClosed().subscribe(res => {
    //   if (res && res.added) {
    //     this.refresh();
    //   }
    // });
  }

  refresh(): void {
  }

  ngOnInit(): void {
    this.refresh();
    this.sortedAddressBook = [
      {name: 'Johny smithy', label: 'Test account', address: '243dsgds4543'},

    ];
    // this.sortedAddressBook = this.addressFilter.valueChanges
    //   .pipe(
    //     startWith(''),
    //     map(value => this._filter(value))
    //   );
  }

  delete(/*TODO: zero args inside html: id: number, e: Event*/): void {
    // e.stopPropagation();
  }

  selectContact(contact: any): void {
    if (contact.confirmed) {
      this.contactSelected.emit(contact);
    }
    else {
      // const dialogRef = this.dialog.open(ConfirmAddressbookDialogComponent, {
      //   data: { contactId: contact.id },
      //   width: '50rem'
      // });
      // dialogRef.afterClosed().subscribe(res => {
      //   // Uselect contact if not confirmed
      //   this.contactSelected.emit(null);
      //   this.refresh();
      // });
    }
  }

  private _filter(value: string): any[] {
    if (!value) {
      return this.contacts;
    }
    const filterValue = value.toLowerCase();

    return this.contacts.filter(option => {
      if (filterValue.length === 1) {
        return option.name.toLowerCase().startsWith(filterValue) || option.surname.toLowerCase().startsWith(filterValue);
      }
      return option.name.toLowerCase().includes(filterValue) || option.surname.toLowerCase().includes(filterValue);
    });
  }
}
