import { Injectable } from '@angular/core';
import { HttpInterceptor, HttpRequest, HttpHandler, HttpEvent, HttpErrorResponse, HttpResponse } from '@angular/common/http';
import { throwError, Observable, EMPTY } from 'rxjs';
import { catchError, exhaustMap } from 'rxjs/operators';
import { MatDialog } from '@angular/material/dialog';
import { TwoFactorAuthDialogComponent } from './components/two-factor-auth-dialog/TwoFactorAuthDialogComponent';

@Injectable()
export class TwoFactorAuthInterceptor implements HttpInterceptor {
  constructor(
    private dialog: MatDialog,
  ) {
  }

  intercept(
    request: HttpRequest<any>,
    next: HttpHandler
  ): Observable<HttpEvent<any>> {

    const duplicate = request.clone({ body: { ...request.body } });
    return next.handle(duplicate);

    // return next.handle(request)
    //   .pipe(
    //     catchError((error: HttpErrorResponse) => {
    //       if (error.error &&
    //         error.error.error == 'required' &&
    //         error.error.error_param == 'authenticatorCode'
    //       ) {
    //         return this.dialog.open(TwoFactorAuthDialogComponent, {width: '35rem'}).afterClosed()
    //         .pipe(
    //           exhaustMap(result => {
    //             if (!result) {
    //               return EMPTY;
    //             }

    //             const duplicate = request.clone({ body: { ...request.body, authenticatorCode: result.authenticatorCode } });
    //             return next.handle(duplicate);
    //           })
    //         );
    //       } else {
    //         return throwError(error);
    //       }
    //     }),

    //   );
  }
}
