import { WalletTypesLabelPipe } from './pipes/WalletTypesLabelPipe';
import { AssetTypesLabelPipe } from './pipes/AssetTypesLabelPipe';
import { NetworkFeeLabelPipe } from './pipes/NetworkFeeLabelPipe';
import { ConfirmPaymentDialogComponent } from './components/confirm-payment-dialog/ConfirmPaymentDialogComponent';
import { NgModule, ModuleWithProviders } from '@angular/core';
import { CommonModule, DatePipe } from '@angular/common';
import { FlexLayoutModule } from '@angular/flex-layout';
import { MaterialModule } from '@app/MaterialModule';
import { LoaderComponent } from './loader/LoaderComponent';
import { ReactiveFormsModule } from '@angular/forms';
import { TranslateModule } from '@ngx-translate/core';
import { SweetAlert2Module } from '@sweetalert2/ngx-sweetalert2';
import { SwalService } from './services/SwalService';
import { AccountService } from './services/AccountService';
import { AccountPipe } from './pipes/AccountPipe';
import { AccountsPipe } from './pipes/AccountsPipe';
import { CurrencyService } from './services/CurrencyService';
import { CurrencyPipe } from './pipes/CurrencyPipe';
import { TransactionService } from './services/TransactionService';
import { TransactionPipe } from './pipes/TransactionPipe';
import { UserService } from './services/UserService';
import { HTTP_INTERCEPTORS } from '@angular/common/http';
import { TwoFactorAuthInterceptor } from './TwoFactorAuthInterceptor';
import { BasicAuthInterceptor } from './BasicAuthInterceptor';
import { OtpAuthInterceptor } from './OtpAuthInterceptor';
import { ExchangeRatesService } from './services/ExchangeRatesService';
import { FormsModule } from '@angular/forms';
import { OnlyNumberDirective } from './directives/onlynumber.directive';
import { RouterModule } from '@angular/router';
import { HideValueDirective } from './directives/hideValues.directive';
import { CurrenciesPipe } from './pipes/CurrenciesPipe';
import { TicketService } from './services/TicketService';
import { KycTierService } from './services/KycTierService';
import { EntryService } from './services/EntryService';
import { IconService } from './services/IconService';
import { TwoFactorAuthDialogComponent } from './components/two-factor-auth-dialog/TwoFactorAuthDialogComponent';
import { OtpAuthDialogComponent } from './components/otp-auth-dialog/OtpAuthDialogComponent';
import { BasicAuthDialogComponent } from './components/basic-auth-dialog/BasicAuthDialogComponent';
import { DialogComponent } from './components/dialog-component/DialogComponent';
import { EnableTwoFactorContentComponent } from './components/dialog-component/dialog-content/enable-two-factor-content/EnableTwoFactorContentComponent';
import { RecoveryEmailAddContentComponent } from './components/dialog-component/dialog-content/recovery-email-add-content/RecoveryEmailAddContentComponent';
// tslint:disable-next-line: max-line-length
import { RecoveryEmailEditContentComponent } from './components/dialog-component/dialog-content/recovery-email-edit-content/RecoveryEmailEditContentComponent';
import { RecoveryPhoneAddContentComponent } from './components/dialog-component/dialog-content/recovery-phone-add-content/RecoveryPhoneAddContentComponent';
// tslint:disable-next-line: max-line-length
import { RecoveryPhoneEditContentComponent } from './components/dialog-component/dialog-content/recovery-phone-edit-content/RecoveryPhoneEditContentComponent';
import { ReceiveAmountContentComponent } from './components/dialog-component/dialog-content/receive-amount-content/ReceiveAmountContentComponent';
import { CreateWalletComponent } from './components/dialog-component/dialog-content/create-wallet-content/CreateWalletComponent';
import { QRCodeModule } from 'angularx-qrcode';
import { CheckboxStatusComponent } from './components/checkbox-status-component/CheckboxStatusComponent';
import { SelectComponent } from './components/select-component/SelectComponent';
import { KycGoldPaymentContentComponent } from './components/dialog-component/dialog-content/kyc-gold-payment-content/KycGoldPaymentContentComponent';
import { TicketDetailsContentComponent } from './components/dialog-component/dialog-content/ticket-details-content/TicketDetailsContentComponent';
import { TransactionDetailsContent } from './components/dialog-component/dialog-content/transaction-details-content/TransactionDetailsContent';
import { QrScannerDialogComponent } from './components/qr-scanner/QrScannerComponent';
import { AddressBookComponent } from './components/address-book/AddressBookComponent';
import {
  AccountsTableComponent,
  PendingTableComponent,
  TurnoverTableComponent,
  TurnoverTableCellComponent,
  TicketTableComponent,
  TransactionStatementTableComponent,
} from './components/tables';
import { TableFilterComponent } from './components/table-filter/TableFilterComponent';
import {
  PasswordInputFieldComponent,
  TextInputFieldComponent,
  TextareaInputFieldComponent,
  NumberInputFieldComponent,
  EmailInputFieldComponent,
  CountryInputFieldComponent,
  PhoneNumberInputFieldComponent,
  DateInputFieldComponent
} from './components/input-fields';
import { ZXingScannerModule } from '@zxing/ngx-scanner';
import { NgxDaterangepickerMd } from 'ngx-daterangepicker-material';
import { InviteCodeDialogComponent } from './components/invite-code-dialog/InviteCodeDialog';
import { CreateVaultContentComponent } from './components/dialog-component/dialog-content/create-vault-content/CreateVaultContentComponent';
import { SystemEventBus } from './event-bus/system.event.bus';

@NgModule({
  imports: [
    RouterModule,
    FormsModule,
    NgxDaterangepickerMd,
    FlexLayoutModule,
    MaterialModule,
    CommonModule,
    ZXingScannerModule,
    ReactiveFormsModule,
    TranslateModule,
    QRCodeModule,
    SweetAlert2Module,
  ],
  declarations: [
    DateInputFieldComponent,
    PhoneNumberInputFieldComponent,
    CountryInputFieldComponent,
    InviteCodeDialogComponent,
    AddressBookComponent,
    QrScannerDialogComponent,
    TransactionDetailsContent,
    CreateVaultContentComponent,
    TransactionStatementTableComponent,
    TableFilterComponent,
    TicketDetailsContentComponent,
    TicketTableComponent,
    NumberInputFieldComponent,
    EmailInputFieldComponent,
    PasswordInputFieldComponent,
    TextInputFieldComponent,
    TextareaInputFieldComponent,
    KycGoldPaymentContentComponent,
    TurnoverTableCellComponent,
    TurnoverTableComponent,
    PendingTableComponent,
    AccountsTableComponent,
    SelectComponent,
    CheckboxStatusComponent,
    ReceiveAmountContentComponent,
    RecoveryEmailEditContentComponent,
    RecoveryEmailAddContentComponent,
    RecoveryPhoneAddContentComponent,
    RecoveryPhoneEditContentComponent,
    EnableTwoFactorContentComponent,
    CreateWalletComponent,
    DialogComponent,
    TwoFactorAuthDialogComponent,
    OtpAuthDialogComponent,
    BasicAuthDialogComponent,
    HideValueDirective,
    OnlyNumberDirective,
    LoaderComponent,
    AccountPipe,
    AccountsPipe,
    CurrencyPipe,
    CurrenciesPipe,
    TransactionPipe,
    ConfirmPaymentDialogComponent,
    NetworkFeeLabelPipe,
    AssetTypesLabelPipe,
    WalletTypesLabelPipe
  ],
  exports: [
    DateInputFieldComponent,
    PhoneNumberInputFieldComponent,
    CountryInputFieldComponent,
    NgxDaterangepickerMd,
    AddressBookComponent,
    ZXingScannerModule,
    QrScannerDialogComponent,
    TransactionDetailsContent,
    TransactionStatementTableComponent,
    TableFilterComponent,
    TicketDetailsContentComponent,
    TicketTableComponent,
    KycGoldPaymentContentComponent,
    CreateVaultContentComponent,
    TurnoverTableCellComponent,
    TurnoverTableComponent,
    NumberInputFieldComponent,
    EmailInputFieldComponent,
    PasswordInputFieldComponent,
    TextInputFieldComponent,
    TextareaInputFieldComponent,
    PendingTableComponent,
    AccountsTableComponent,
    SelectComponent,
    CheckboxStatusComponent,
    ReceiveAmountContentComponent,
    RecoveryEmailEditContentComponent,
    RecoveryEmailAddContentComponent,
    RecoveryPhoneAddContentComponent,
    RecoveryPhoneEditContentComponent,
    EnableTwoFactorContentComponent,
    CreateWalletComponent,
    HideValueDirective,
    OnlyNumberDirective,
    LoaderComponent,
    FlexLayoutModule,
    MaterialModule,
    CommonModule,
    InviteCodeDialogComponent,
    DialogComponent,
    TwoFactorAuthDialogComponent,
    OtpAuthDialogComponent,
    BasicAuthDialogComponent,
    FormsModule,
    ReactiveFormsModule,
    TranslateModule,
    QRCodeModule,
    SweetAlert2Module,
    AccountPipe,
    AccountsPipe,
    CurrencyPipe,
    CurrenciesPipe,
    TransactionPipe,
    ConfirmPaymentDialogComponent,
    NetworkFeeLabelPipe,
    AssetTypesLabelPipe,
    WalletTypesLabelPipe
  ],
  entryComponents: [
    AddressBookComponent,
    DialogComponent,
    InviteCodeDialogComponent,
    TwoFactorAuthDialogComponent,
    OtpAuthDialogComponent,
    BasicAuthDialogComponent,
    QrScannerDialogComponent,
    ConfirmPaymentDialogComponent
  ],
})
export class SharedModule {
  static forRoot(): ModuleWithProviders<SharedModule> {
    return {
      ngModule: SharedModule,
      providers: [
        IconService,
        SwalService,
        AccountService,
        CurrencyService,
        TransactionService,
        UserService,
        ExchangeRatesService,
        TicketService,
        KycTierService,
        EntryService,
        DatePipe,
        NetworkFeeLabelPipe,
        SystemEventBus,
        {
          provide: HTTP_INTERCEPTORS,
          useClass: TwoFactorAuthInterceptor,
          multi: true,
        },
        {
          provide: HTTP_INTERCEPTORS,
          useClass: BasicAuthInterceptor,
          multi: true,
        },
        {
          provide: HTTP_INTERCEPTORS,
          useClass: OtpAuthInterceptor,
          multi: true,
        },
      ],
    };
  }
}
